<?php

/*****************************************************

SEB'S XML PARSER v0.1a
----------------------

written by Sebastian Bechtold
contact: sebastian_bechtold@web.de

*****************************************************/
function formatXmlString($xml) {  
  
  // add marker linefeeds to aid the pretty-tokeniser (adds a linefeed between all tag-end boundaries)
  $xml = preg_replace('/(>)(<)(\/*)/', "$1\n$2$3", $xml);
  
  // now indent the tags
  $token      = strtok($xml, "\n");
  $result     = ''; // holds formatted version as it is built
  $pad        = 0; // initial indent
  $matches    = array(); // returns from preg_matches()
  
  // scan each line and adjust indent based on opening/closing tags
  while ($token !== false) : 
  
    // test for the various tag states
    
    // 1. open and closing tags on same line - no change
    if (preg_match('/.+<\/\w[^>]*>$/', $token, $matches)) : 
      $indent=0;
    // 2. closing tag - outdent now
    elseif (preg_match('/^<\/\w/', $token, $matches)) :
      $pad-=4;
    // 3. opening tag - don't pad this one, only subsequent tags
    elseif (preg_match('/^<\w[^>]*[^\/]>.*$/', $token, $matches)) :
      $indent=4;
    // 4. no indentation needed
    else :
      $indent = 0; 
    endif;
    
    // pad the line with the required number of leading spaces
    $line    = str_pad($token, strlen($token)+$pad, ' ', STR_PAD_LEFT);
    $result .= $line . "\n"; // add to the cumulative result, with linefeed
    $token   = strtok("\n"); // get the next token
    $pad    += $indent; // update the pad size for subsequent lines    
  endwhile; 
  
  return $result;
}

class XML_document
{
	function callback_openElement($parser, $name, $attributes)

	// ########  called by start element event handler to add new elements to xml data and update stack ########
	{
		$element = & $this->XMLdata;	// start at root...

		foreach($this->XMLstack as $stack_element)	// ...and jump up to the current element guided by stack information
		{
			$element = & $element[$stack_element][count($element[$stack_element]) - 1];
		}

        $element[$name][]['ATTRS'] = $attributes;	// create element by applying attributes to it

		array_push($this->XMLstack, $name);	// finally, add element name to stack
	}


	function callback_closeElement($parser, $name)

	// ########  called by end element event handler to remove last element from stack ########
	{
		array_pop($this->XMLstack);
	}


	function callback_cdata($parser, $cdata)

	// ########  called by cdata element event handler to apply current cdata to current element ########
	{
		$element = & $this->XMLdata;	// start at root...

	    foreach($this->XMLstack as $stack_element)	// ...and jump up to the current element guided by stack information
		{
            $element = & $element[$stack_element][count($element[$stack_element])-1];
        }
        $buff = $cdata;
        $buff = str_replace("€","&euro",$buff);
        $buff = utf8_decode($buff);
        $buff = str_replace("\n","",$buff);
        $buff = str_replace("","&euro",$buff);

        $element['CDATA'] .= $buff;	// apply cdata to current element
	}


	function XML_document($file)

	// ########  create parser instance, open and parse xml document ########
	{
		if (!($fp = fopen($file, 'r')))
		{
			//die("could not open XML file");
			echo "could not open XML file";
			return -1;
		}

		$this->XMLdata = array();
		$this->XMLstack = array();

		$this->parser = xml_parser_create();

		xml_set_object($this->parser, & $this);
		xml_set_element_handler($this->parser, 'callback_openElement', 'callback_closeElement');
		xml_set_character_data_handler($this->parser, 'callback_cdata');

		while ($data = fread($fp, 60000))
		{
			if (!xml_parse($this->parser, $data, feof($fp)))
			{
				$hmpf = sprintf("XML error: %s at line %d\n", xml_error_string(xml_get_error_code($this->parser)), xml_get_current_line_number($this->parser));
				print_r ($hmpf);
			//	mail ("stephan.schach@lemsterpoort.com","XML error ".$hmpf,$hmpf."\n".$file);
    copy($file,dirname(__FILE__)."/error/".basename($file));

        $handle = fopen(dirname(__FILE__)."/error/log.txt", 'a');
fputs($handle, formatXmlString($hmpf."".$file."\n\r"));
fclose($handle);

			}
		}

		fclose($fp);
		xml_parser_free($this->parser);
	}
}

?>